
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM]') AND type in (N'U'))
BEGIN
   CREATE TABLE [dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM](
	   [CD_CTR] [bigint] NOT NULL,
	   [CD_EMP] [int] NOT NULL,
	   [CD_FILIAL] [int] NOT NULL,
	   [CD_VD] [int] NOT NULL,
	   [CD_IMP] [int] NOT NULL,
	   [CD_PROD] [int] NOT NULL,
	   [CD_IT] [int] NOT NULL,
	   [QT_IT] [money] NOT NULL,
	   [ST_ENV] [int] NOT NULL,
	   [NSU_RESPOSTA] [int] NULL,
	   [COD_RESPOSTA] [varchar](2) NULL,
    CONSTRAINT [PK_PDV_VD_DEV_EST_PROD_IMP_PBM] PRIMARY KEY CLUSTERED 
   (
	   [CD_CTR] ASC
   )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
   ) ON [PRIMARY]
END
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM]') AND name = N'IX_PDV_VD_DEV_EST_PROD_IMP_PBM')
CREATE NONCLUSTERED INDEX [IX_PDV_VD_DEV_EST_PROD_IMP_PBM] ON [dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM]
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_VD] ASC,
	[CD_IMP] ASC,
	[CD_PROD] ASC,
	[CD_IT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM]') AND name = N'IX_PDV_VD_DEV_EST_PROD_IMP_PBM_1')
CREATE NONCLUSTERED INDEX [IX_PDV_VD_DEV_EST_PROD_IMP_PBM_1] ON [dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM]
(
	[ST_ENV] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_PDV_VD_DEV_EST_PROD_IMP_PBM_ST_ENV]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM] ADD  CONSTRAINT [DF_PDV_VD_DEV_EST_PROD_IMP_PBM_ST_ENV]  DEFAULT ((0)) FOR [ST_ENV]
END
GO

IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PDV_VD_DEV_EST_PROD_IMP_PBM_PDV_VD_DEV_EST_PROD_IMP]') AND parent_object_id = OBJECT_ID(N'[dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM]'))
ALTER TABLE [dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM]  WITH CHECK ADD  CONSTRAINT [FK_PDV_VD_DEV_EST_PROD_IMP_PBM_PDV_VD_DEV_EST_PROD_IMP] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_VD], [CD_IMP], [CD_PROD], [CD_IT])
REFERENCES [dbo].[PDV_VD_DEV_EST_PROD_IMP] ([CD_EMP], [CD_FILIAL], [CD_VD], [CD_IMP], [CD_PROD], [CD_IT])
GO

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_PDV_VD_DEV_EST_PROD_IMP_PBM_PDV_VD_DEV_EST_PROD_IMP]') AND parent_object_id = OBJECT_ID(N'[dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM]'))
ALTER TABLE [dbo].[PDV_VD_DEV_EST_PROD_IMP_PBM] CHECK CONSTRAINT [FK_PDV_VD_DEV_EST_PROD_IMP_PBM_PDV_VD_DEV_EST_PROD_IMP]
GO
